/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.infrastructure.transfer;

import com.zurrtum.create.infrastructure.fluids.FluidInventory;
import com.zurrtum.create.infrastructure.fluids.FluidStack;
import com.zurrtum.create.infrastructure.fluids.SidedFluidInventory;
import com.zurrtum.create.infrastructure.transfer.FluidInventoryStorage;
import com.zurrtum.create.infrastructure.transfer.SlotRangeCache;
import it.unimi.dsi.fastutil.objects.Object2IntLinkedOpenCustomHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntSortedMap;
import it.unimi.dsi.fastutil.objects.ObjectBidirectionalIterator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.SlottedStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleSlotStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_2350;
import net.minecraft.class_3611;
import net.minecraft.class_9326;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FluidInventoryWrapper<T extends Storage<FluidVariant>, S extends StorageView<FluidVariant>>
implements FluidInventory {
    protected T storage;
    protected int capacity;

    public FluidInventoryWrapper(T storage) {
        this.storage = storage;
        this.init();
    }

    public static FluidInventory of(Storage<FluidVariant> storage) {
        FluidInventoryWrapper inventory;
        if (storage instanceof SlottedStorage) {
            SlottedStorage slottedStorage = (SlottedStorage)storage;
            inventory = new Slotted((SlottedStorage<FluidVariant>)slottedStorage);
        } else {
            inventory = new Direct(storage);
        }
        if (storage.supportsInsertion() && storage.supportsExtraction()) {
            return inventory;
        }
        return new Filter(inventory);
    }

    @Override
    public void method_5448() {
        try (Transaction transaction = Transaction.openOuter();){
            for (StorageView view : this.storage.nonEmptyViews()) {
                view.extract((Object)((FluidVariant)view.getResource()), view.getAmount(), (TransactionContext)transaction);
            }
            transaction.commit();
        }
    }

    @Override
    public int count(FluidStack stack) {
        int maxAmount = stack.getAmount();
        if (maxAmount == 0) {
            return 0;
        }
        return this.count(stack, maxAmount);
    }

    @Override
    public int count(FluidStack stack, int maxAmount) {
        try (Transaction transaction = Transaction.openOuter();){
            long extract = this.storage.extract((Object)FluidVariant.of((class_3611)stack.getFluid(), (class_9326)stack.getComponentChanges()), (long)maxAmount, (TransactionContext)transaction);
            transaction.abort();
            int n = (int)extract;
            return n;
        }
    }

    @Override
    public FluidStack count(Predicate<FluidStack> predicate) {
        try (Transaction transaction = Transaction.openOuter();){
            for (StorageView view : this.storage.nonEmptyViews()) {
                FluidVariant variant = (FluidVariant)view.getResource();
                FluidStack stack = FluidInventoryStorage.getCachedStack(variant);
                if (!predicate.test(stack)) continue;
                long extract = view.extract((Object)variant, view.getAmount(), (TransactionContext)transaction);
                if (extract == 0L) continue;
                transaction.abort();
                FluidStack fluidStack = stack.directCopy((int)extract);
                return fluidStack;
            }
        }
        return FluidStack.EMPTY;
    }

    @Override
    public FluidStack count(Predicate<FluidStack> predicate, int maxAmount) {
        if (maxAmount == 0) {
            return FluidStack.EMPTY;
        }
        try (Transaction transaction = Transaction.openOuter();){
            for (StorageView view : this.storage.nonEmptyViews()) {
                FluidVariant variant = (FluidVariant)view.getResource();
                FluidStack stack = FluidInventoryStorage.getCachedStack(variant);
                if (!predicate.test(stack)) continue;
                long extract = this.storage.extract((Object)variant, (long)maxAmount, (TransactionContext)transaction);
                if (extract == 0L) continue;
                transaction.abort();
                FluidStack fluidStack = stack.directCopy((int)extract);
                return fluidStack;
            }
            transaction.abort();
        }
        return FluidStack.EMPTY;
    }

    @Override
    public FluidStack countAny() {
        try (Transaction transaction = Transaction.openOuter();){
            for (StorageView view : this.storage.nonEmptyViews()) {
                FluidVariant variant = (FluidVariant)view.getResource();
                FluidStack stack = FluidInventoryStorage.getCachedStack(variant);
                long extract = view.extract((Object)variant, view.getAmount(), (TransactionContext)transaction);
                if (extract == 0L) continue;
                transaction.abort();
                FluidStack fluidStack = stack.directCopy((int)extract);
                return fluidStack;
            }
            transaction.abort();
        }
        return FluidStack.EMPTY;
    }

    @Override
    public FluidStack countAny(int maxAmount) {
        if (maxAmount == 0) {
            return FluidStack.EMPTY;
        }
        try (Transaction transaction = Transaction.openOuter();){
            for (StorageView view : this.storage.nonEmptyViews()) {
                FluidVariant variant = (FluidVariant)view.getResource();
                FluidStack stack = FluidInventoryStorage.getCachedStack(variant);
                long extract = this.storage.extract((Object)variant, (long)maxAmount, (TransactionContext)transaction);
                if (extract == 0L) continue;
                transaction.abort();
                FluidStack fluidStack = stack.directCopy((int)extract);
                return fluidStack;
            }
            transaction.abort();
        }
        return FluidStack.EMPTY;
    }

    @Override
    public int countSpace(FluidStack stack) {
        int maxAmount = stack.getAmount();
        if (maxAmount == 0) {
            return 0;
        }
        return this.countSpace(stack, maxAmount);
    }

    @Override
    public int countSpace(FluidStack stack, int maxAmount) {
        try (Transaction transaction = Transaction.openOuter();){
            long insert = this.storage.insert((Object)FluidVariant.of((class_3611)stack.getFluid(), (class_9326)stack.getComponentChanges()), (long)maxAmount, (TransactionContext)transaction);
            transaction.abort();
            int n = (int)insert;
            return n;
        }
    }

    @Override
    public boolean countSpace(List<FluidStack> stacks) {
        int listSize = stacks.size();
        if (listSize == 0) {
            return true;
        }
        if (listSize == 1) {
            int amount;
            FluidStack stack = stacks.getFirst();
            return this.countSpace(stack, amount = stack.getAmount()) == amount;
        }
        Object2IntLinkedOpenCustomHashMap map = new Object2IntLinkedOpenCustomHashMap(FLUID_STACK_HASH_STRATEGY);
        for (FluidStack stack : stacks) {
            map.merge((Object)stack, stack.getAmount(), Integer::sum);
        }
        Object2IntSortedMap.FastSortedEntrySet entries = map.object2IntEntrySet();
        if (entries.size() == 1) {
            int amount;
            Object2IntMap.Entry entry = (Object2IntMap.Entry)entries.first();
            FluidStack stack = (FluidStack)entry.getKey();
            return this.countSpace(stack, amount = entry.getIntValue()) == amount;
        }
        try (Transaction transaction = Transaction.openOuter();){
            ObjectBidirectionalIterator iterator = entries.fastIterator();
            do {
                Object2IntMap.Entry entry = (Object2IntMap.Entry)iterator.next();
                FluidStack stack = (FluidStack)entry.getKey();
                int amount = entry.getIntValue();
                long insert = this.storage.insert((Object)FluidVariant.of((class_3611)stack.getFluid(), (class_9326)stack.getComponentChanges()), (long)amount, (TransactionContext)transaction);
                if (insert >= (long)amount) continue;
                transaction.abort();
                boolean bl = false;
                return bl;
            } while (iterator.hasNext());
            transaction.abort();
            boolean bl = true;
            return bl;
        }
    }

    @Override
    public int extract(FluidStack stack) {
        int maxAmount = stack.getAmount();
        if (maxAmount == 0) {
            return 0;
        }
        return this.extract(stack, maxAmount);
    }

    @Override
    public int extract(FluidStack stack, int maxAmount) {
        try (Transaction transaction = Transaction.openOuter();){
            long extract = this.storage.extract((Object)FluidVariant.of((class_3611)stack.getFluid(), (class_9326)stack.getComponentChanges()), (long)maxAmount, (TransactionContext)transaction);
            transaction.commit();
            int n = (int)extract;
            return n;
        }
    }

    @Override
    public FluidStack extract(Predicate<FluidStack> predicate) {
        try (Transaction transaction = Transaction.openOuter();){
            for (StorageView view : this.storage.nonEmptyViews()) {
                FluidVariant variant = (FluidVariant)view.getResource();
                FluidStack stack = FluidInventoryStorage.getCachedStack(variant);
                if (!predicate.test(stack)) continue;
                long extract = view.extract((Object)variant, view.getAmount(), (TransactionContext)transaction);
                if (extract == 0L) continue;
                transaction.commit();
                FluidStack fluidStack = stack.directCopy((int)extract);
                return fluidStack;
            }
        }
        return FluidStack.EMPTY;
    }

    @Override
    public FluidStack extract(Predicate<FluidStack> predicate, int maxAmount) {
        if (maxAmount == 0) {
            return FluidStack.EMPTY;
        }
        try (Transaction transaction = Transaction.openOuter();){
            for (StorageView view : this.storage.nonEmptyViews()) {
                FluidVariant variant = (FluidVariant)view.getResource();
                FluidStack stack = FluidInventoryStorage.getCachedStack(variant);
                if (!predicate.test(stack)) continue;
                long extract = this.storage.extract((Object)variant, (long)maxAmount, (TransactionContext)transaction);
                if (extract == 0L) continue;
                transaction.commit();
                FluidStack fluidStack = stack.directCopy((int)extract);
                return fluidStack;
            }
            transaction.abort();
        }
        return FluidStack.EMPTY;
    }

    @Override
    public FluidStack extractAny() {
        try (Transaction transaction = Transaction.openOuter();){
            for (StorageView view : this.storage.nonEmptyViews()) {
                FluidVariant variant;
                long extract = view.extract((Object)(variant = (FluidVariant)view.getResource()), view.getAmount(), (TransactionContext)transaction);
                if (extract == 0L) continue;
                transaction.commit();
                FluidStack fluidStack = FluidInventoryStorage.getCachedStack(variant).directCopy((int)extract);
                return fluidStack;
            }
            transaction.abort();
        }
        return FluidStack.EMPTY;
    }

    @Override
    public FluidStack extractAny(int maxAmount) {
        if (maxAmount == 0) {
            return FluidStack.EMPTY;
        }
        try (Transaction transaction = Transaction.openOuter();){
            for (StorageView view : this.storage.nonEmptyViews()) {
                FluidVariant variant;
                long extract = view.extract((Object)(variant = (FluidVariant)view.getResource()), (long)maxAmount, (TransactionContext)transaction);
                if (extract == 0L) continue;
                transaction.commit();
                FluidStack fluidStack = FluidInventoryStorage.getCachedStack(variant).directCopy((int)extract);
                return fluidStack;
            }
            transaction.abort();
        }
        return FluidStack.EMPTY;
    }

    @Override
    public int forceInsert(FluidStack stack) {
        return this.insert(stack);
    }

    @Override
    public int forceInsert(FluidStack stack, int maxAmount) {
        return this.insert(stack, maxAmount);
    }

    @Override
    public boolean forcePreciseInsert(FluidStack stack) {
        return this.preciseInsert(stack);
    }

    @Override
    public boolean forcePreciseInsert(FluidStack stack, int maxAmount) {
        return this.preciseInsert(stack, maxAmount);
    }

    @Override
    public int getMaxAmountPerStack() {
        return this.capacity;
    }

    protected abstract S getSlot(int var1);

    @Override
    public FluidStack getStack(int slot) {
        if (slot >= this.size()) {
            return FluidStack.EMPTY;
        }
        S view = this.getSlot(slot);
        if (view == null) {
            return FluidStack.EMPTY;
        }
        FluidVariant variant = (FluidVariant)view.getResource();
        return new FluidStack(variant.getFluid(), view.getAmount(), variant.getComponents());
    }

    protected void init() {
        int max = 0;
        for (StorageView view : this.storage) {
            long capacity = view.getCapacity();
            if ((long)max <= capacity) continue;
            max = (int)capacity;
        }
        this.capacity = max;
    }

    protected abstract void insert(S var1, FluidVariant var2, int var3, Transaction var4);

    @Override
    public int insert(FluidStack stack) {
        int maxAmount = stack.getAmount();
        if (maxAmount == 0) {
            return 0;
        }
        return this.insert(stack, maxAmount);
    }

    @Override
    public int insert(FluidStack stack, int maxAmount) {
        try (Transaction transaction = Transaction.openOuter();){
            long insert = this.storage.insert((Object)FluidVariant.of((class_3611)stack.getFluid(), (class_9326)stack.getComponentChanges()), (long)maxAmount, (TransactionContext)transaction);
            transaction.commit();
            int n = (int)insert;
            return n;
        }
    }

    @Override
    public List<FluidStack> insert(List<FluidStack> stacks) {
        int listSize = stacks.size();
        if (listSize == 0) {
            return stacks;
        }
        if (listSize == 1) {
            int insert;
            FluidStack stack = stacks.getFirst();
            int amount = stack.getAmount();
            if (amount == (insert = this.insert(stacks.getFirst()))) {
                return List.of();
            }
            if (insert == 0) {
                return stacks;
            }
            return List.of(stack.directCopy(amount - insert));
        }
        Object2IntLinkedOpenCustomHashMap map = new Object2IntLinkedOpenCustomHashMap(FLUID_STACK_HASH_STRATEGY);
        for (FluidStack stack : stacks) {
            map.merge((Object)stack, stack.getAmount(), Integer::sum);
        }
        Object2IntSortedMap.FastSortedEntrySet entries = map.object2IntEntrySet();
        if (entries.size() == 1) {
            int insert;
            Object2IntMap.Entry entry = (Object2IntMap.Entry)entries.first();
            FluidStack stack = (FluidStack)entry.getKey();
            int amount = entry.getIntValue();
            if (amount == (insert = this.insert(stack, amount))) {
                return List.of();
            }
            if (insert == 0) {
                return stacks;
            }
            return List.of(stack.directCopy(amount - insert));
        }
        try (Transaction transaction = Transaction.openOuter();){
            boolean dirty = false;
            ObjectBidirectionalIterator iterator = entries.fastIterator();
            do {
                Object2IntMap.Entry entry = (Object2IntMap.Entry)iterator.next();
                FluidStack stack = (FluidStack)entry.getKey();
                int amount = entry.getIntValue();
                long insert = this.storage.insert((Object)FluidVariant.of((class_3611)stack.getFluid(), (class_9326)stack.getComponentChanges()), (long)amount, (TransactionContext)transaction);
                if (insert == (long)amount) {
                    iterator.remove();
                    if (entries.isEmpty()) {
                        transaction.commit();
                        List<FluidStack> list = List.of();
                        return list;
                    }
                    dirty = true;
                    continue;
                }
                if (insert == 0L) continue;
                entry.setValue(amount - (int)insert);
                dirty = true;
            } while (iterator.hasNext());
            if (dirty) {
                ArrayList<FluidStack> result = new ArrayList<FluidStack>();
                for (Object2IntMap.Entry entry : entries) {
                    FluidStack stack = (FluidStack)entry.getKey();
                    int amount = entry.getIntValue();
                    if (stack.getAmount() == amount) {
                        result.add(stack);
                        continue;
                    }
                    result.add(stack.directCopy(amount));
                }
                transaction.commit();
                Object object = result;
                return object;
            }
            List<FluidStack> list = stacks;
            return list;
        }
    }

    @Override
    public int insertExist(FluidStack stack) {
        if (stack.isEmpty()) {
            return 0;
        }
        try (Transaction transaction = Transaction.openOuter();){
            long insert = this.storage.insert((Object)FluidVariant.of((class_3611)stack.getFluid(), (class_9326)stack.getComponentChanges()), (long)stack.getAmount(), (TransactionContext)transaction);
            transaction.commit();
            int n = (int)insert;
            return n;
        }
    }

    @Override
    public boolean isEmpty() {
        java.util.Iterator iterator = this.storage.nonEmptyViews().iterator();
        if (iterator.hasNext()) {
            StorageView view = (StorageView)iterator.next();
            return false;
        }
        return true;
    }

    @Override
    @NotNull
    public java.util.Iterator<FluidStack> iterator() {
        return this.storage.supportsExtraction() ? new Iterator((Storage<FluidVariant>)this.storage) : Collections.emptyIterator();
    }

    @Override
    public boolean preciseExtract(FluidStack stack) {
        if (stack.isEmpty()) {
            return true;
        }
        try (Transaction transaction = Transaction.openOuter();){
            int amount = stack.getAmount();
            long extract = this.storage.extract((Object)FluidVariant.of((class_3611)stack.getFluid(), (class_9326)stack.getComponentChanges()), (long)amount, (TransactionContext)transaction);
            if (extract < (long)amount) {
                transaction.abort();
                boolean bl = false;
                return bl;
            }
            transaction.commit();
            boolean bl = true;
            return bl;
        }
    }

    @Override
    public FluidStack preciseExtract(Predicate<FluidStack> predicate, int maxAmount) {
        if (maxAmount == 0) {
            return FluidStack.EMPTY;
        }
        try (Transaction transaction = Transaction.openOuter();){
            for (StorageView view : this.storage.nonEmptyViews()) {
                long extract;
                FluidVariant variant = (FluidVariant)view.getResource();
                FluidStack stack = FluidInventoryStorage.getCachedStack(variant);
                if (!predicate.test(stack) || (extract = this.storage.extract((Object)variant, (long)maxAmount, (TransactionContext)transaction)) == 0L) continue;
                if (extract == (long)maxAmount) {
                    transaction.commit();
                    FluidStack fluidStack = stack.directCopy(maxAmount);
                    return fluidStack;
                }
                transaction.abort();
            }
        }
        return FluidStack.EMPTY;
    }

    @Override
    public boolean preciseInsert(FluidStack stack) {
        int maxAmount = stack.getAmount();
        if (maxAmount == 0) {
            return true;
        }
        return this.preciseInsert(stack, maxAmount);
    }

    @Override
    public boolean preciseInsert(FluidStack stack, int maxAmount) {
        try (Transaction transaction = Transaction.openOuter();){
            long insert = this.storage.insert((Object)FluidVariant.of((class_3611)stack.getFluid(), (class_9326)stack.getComponentChanges()), (long)maxAmount, (TransactionContext)transaction);
            if (insert < (long)maxAmount) {
                transaction.abort();
                boolean bl = false;
                return bl;
            }
            transaction.commit();
            boolean bl = true;
            return bl;
        }
    }

    @Override
    public boolean preciseInsert(List<FluidStack> stacks) {
        int listSize = stacks.size();
        if (listSize == 0) {
            return true;
        }
        if (listSize == 1) {
            return this.preciseInsert(stacks.getFirst());
        }
        Object2IntLinkedOpenCustomHashMap map = new Object2IntLinkedOpenCustomHashMap(FLUID_STACK_HASH_STRATEGY);
        for (FluidStack stack : stacks) {
            map.merge((Object)stack, stack.getAmount(), Integer::sum);
        }
        Object2IntSortedMap.FastSortedEntrySet entries = map.object2IntEntrySet();
        if (entries.size() == 1) {
            Object2IntMap.Entry entry = (Object2IntMap.Entry)entries.first();
            return this.preciseInsert((FluidStack)entry.getKey(), entry.getIntValue());
        }
        try (Transaction transaction = Transaction.openOuter();){
            ObjectBidirectionalIterator iterator = entries.fastIterator();
            do {
                Object2IntMap.Entry entry = (Object2IntMap.Entry)iterator.next();
                FluidStack stack = (FluidStack)entry.getKey();
                int amount = entry.getIntValue();
                long insert = this.storage.insert((Object)FluidVariant.of((class_3611)stack.getFluid(), (class_9326)stack.getComponentChanges()), (long)amount, (TransactionContext)transaction);
                if (insert >= (long)amount) continue;
                transaction.abort();
                boolean bl = false;
                return bl;
            } while (iterator.hasNext());
            transaction.commit();
            boolean bl = true;
            return bl;
        }
    }

    @Override
    public FluidStack removeStack(int slot) {
        if (slot >= this.size()) {
            return FluidStack.EMPTY;
        }
        S view = this.getSlot(slot);
        if (view == null) {
            return FluidStack.EMPTY;
        }
        FluidVariant variant = (FluidVariant)view.getResource();
        long amount = view.getAmount();
        if (variant.isBlank() || amount == 0L) {
            return FluidStack.EMPTY;
        }
        try (Transaction transaction = Transaction.openOuter();){
            amount = view.extract((Object)variant, amount, (TransactionContext)transaction);
            transaction.commit();
        }
        return new FluidStack(variant.getFluid(), amount, variant.getComponents());
    }

    @Override
    public FluidStack removeStack(int slot, int amount) {
        if (slot >= this.size()) {
            return FluidStack.EMPTY;
        }
        S view = this.getSlot(slot);
        if (view == null) {
            return FluidStack.EMPTY;
        }
        FluidVariant variant = (FluidVariant)view.getResource();
        if (variant.isBlank() || view.getAmount() == 0L) {
            return FluidStack.EMPTY;
        }
        try (Transaction transaction = Transaction.openOuter();){
            amount = (int)view.extract((Object)variant, (long)amount, (TransactionContext)transaction);
            transaction.commit();
        }
        return new FluidStack(variant.getFluid(), amount, variant.getComponents());
    }

    @Override
    public void setStack(int slot, FluidStack stack) {
        if (slot >= this.size()) {
            return;
        }
        S view = this.getSlot(slot);
        if (view == null) {
            return;
        }
        FluidVariant variant = (FluidVariant)view.getResource();
        try (Transaction transaction = Transaction.openOuter();){
            if (variant.isBlank() || view.getAmount() == 0L) {
                if (stack.isEmpty()) {
                    return;
                }
                this.insert(view, FluidVariant.of((class_3611)stack.getFluid(), (class_9326)stack.getComponentChanges()), stack.getAmount(), transaction);
            } else if (FluidInventoryStorage.matches(variant, stack)) {
                int targetAmount;
                int amount = stack.getAmount();
                if (amount == (targetAmount = (int)view.getAmount())) {
                    return;
                }
                int change = targetAmount - amount;
                if (amount < targetAmount) {
                    this.insert(view, variant, change, transaction);
                } else {
                    view.extract((Object)variant, (long)change, (TransactionContext)transaction);
                }
            } else {
                view.extract((Object)variant, view.getAmount(), (TransactionContext)transaction);
                this.insert(view, FluidVariant.of((class_3611)stack.getFluid(), (class_9326)stack.getComponentChanges()), stack.getAmount(), transaction);
            }
            transaction.commit();
        }
    }

    @Override
    public Stream<FluidStack> stream() {
        return this.storage.supportsExtraction() ? FluidInventory.super.stream() : Stream.empty();
    }

    protected static class Slotted
    extends FluidInventoryWrapper<SlottedStorage<FluidVariant>, SingleSlotStorage<FluidVariant>> {
        public Slotted(SlottedStorage<FluidVariant> storage) {
            super(storage);
        }

        @Override
        protected SingleSlotStorage<FluidVariant> getSlot(int slot) {
            return ((SlottedStorage)this.storage).getSlot(slot);
        }

        @Override
        protected void insert(SingleSlotStorage<FluidVariant> view, FluidVariant variant, int amount, Transaction transaction) {
            view.insert((Object)variant, (long)amount, (TransactionContext)transaction);
        }

        @Override
        public int insertExist(FluidStack stack) {
            if (stack.isEmpty()) {
                return 0;
            }
            try (Transaction transaction = Transaction.openOuter();){
                ArrayList<SingleSlotStorage> emptys = new ArrayList<SingleSlotStorage>();
                FluidVariant variant = FluidVariant.of((class_3611)stack.getFluid(), (class_9326)stack.getComponentChanges());
                int maxAmount = stack.getAmount();
                long remaining = maxAmount;
                int size = ((SlottedStorage)this.storage).getSlotCount();
                for (int i = 0; i < size; ++i) {
                    SingleSlotStorage target = ((SlottedStorage)this.storage).getSlot(i);
                    if (target.getAmount() == 0L || target.isResourceBlank()) {
                        emptys.add(target);
                        continue;
                    }
                    long insert = target.insert((Object)variant, remaining, (TransactionContext)transaction);
                    if (insert == remaining) {
                        transaction.commit();
                        int n = maxAmount;
                        return n;
                    }
                    remaining -= insert;
                }
                for (SingleSlotStorage target : emptys) {
                    long insert = target.insert((Object)variant, remaining, (TransactionContext)transaction);
                    if (insert == remaining) {
                        transaction.commit();
                        int n = maxAmount;
                        return n;
                    }
                    remaining -= insert;
                }
                transaction.commit();
                int n = maxAmount - (int)remaining;
                return n;
            }
        }

        @Override
        public int size() {
            return ((SlottedStorage)this.storage).getSlotCount();
        }
    }

    protected static class Direct
    extends FluidInventoryWrapper<Storage<FluidVariant>, StorageView<FluidVariant>> {
        private int size;

        public Direct(Storage<FluidVariant> storage) {
            super(storage);
        }

        @Override
        protected StorageView<FluidVariant> getSlot(int slot) {
            int current = 0;
            for (StorageView view : this.storage) {
                if (current == slot) {
                    return view;
                }
                ++current;
            }
            return null;
        }

        @Override
        protected void init() {
            int count = 0;
            int max = 0;
            for (StorageView view : this.storage) {
                long capacity = view.getCapacity();
                if ((long)max < capacity) {
                    max = (int)capacity;
                }
                ++count;
            }
            this.size = count;
            this.capacity = max;
        }

        @Override
        protected void insert(StorageView<FluidVariant> view, FluidVariant variant, int amount, Transaction transaction) {
            this.storage.insert((Object)variant, (long)amount, (TransactionContext)transaction);
        }

        @Override
        public int size() {
            return this.size;
        }
    }

    public static class Filter
    implements SidedFluidInventory {
        private final int[] slots;
        private final boolean canInsert;
        private final boolean canExtract;
        private final FluidInventoryWrapper<?, ?> inventory;

        public Filter(FluidInventoryWrapper<?, ?> inventory) {
            this.inventory = inventory;
            this.slots = SlotRangeCache.get(inventory.size());
            this.canInsert = inventory.storage.supportsInsertion();
            this.canExtract = inventory.storage.supportsExtraction();
        }

        @Override
        public boolean canExtract(int slot, FluidStack stack, class_2350 dir) {
            return this.canExtract;
        }

        @Override
        public boolean canInsert(int slot, FluidStack stack, @Nullable class_2350 dir) {
            return this.canInsert;
        }

        @Override
        public void method_5448() {
            if (!this.canExtract) {
                return;
            }
            this.inventory.method_5448();
        }

        @Override
        public int count(FluidStack stack, class_2350 side) {
            return this.count(stack);
        }

        @Override
        public int count(FluidStack stack) {
            if (!this.canExtract) {
                return 0;
            }
            return this.inventory.count(stack);
        }

        @Override
        public int count(FluidStack stack, int maxAmount, class_2350 side) {
            return this.count(stack, maxAmount);
        }

        @Override
        public int count(FluidStack stack, int maxAmount) {
            if (!this.canExtract) {
                return 0;
            }
            return this.inventory.count(stack, maxAmount);
        }

        @Override
        public FluidStack count(Predicate<FluidStack> predicate, class_2350 side) {
            return this.count(predicate);
        }

        @Override
        public FluidStack count(Predicate<FluidStack> predicate) {
            if (!this.canExtract) {
                return FluidStack.EMPTY;
            }
            return this.inventory.count(predicate);
        }

        @Override
        public FluidStack count(Predicate<FluidStack> predicate, int maxAmount, class_2350 side) {
            return this.count(predicate, maxAmount);
        }

        @Override
        public FluidStack count(Predicate<FluidStack> predicate, int maxAmount) {
            if (!this.canExtract) {
                return FluidStack.EMPTY;
            }
            return this.inventory.count(predicate, maxAmount);
        }

        @Override
        public FluidStack countAny(class_2350 side) {
            return this.countAny();
        }

        @Override
        public FluidStack countAny() {
            if (!this.canExtract) {
                return FluidStack.EMPTY;
            }
            return this.inventory.countAny();
        }

        @Override
        public FluidStack countAny(int maxAmount, class_2350 side) {
            return this.countAny(maxAmount);
        }

        @Override
        public FluidStack countAny(int maxAmount) {
            if (!this.canExtract) {
                return FluidStack.EMPTY;
            }
            return this.inventory.countAny(maxAmount);
        }

        @Override
        public int countSpace(FluidStack stack, class_2350 side) {
            return this.countSpace(stack);
        }

        @Override
        public int countSpace(FluidStack stack) {
            if (!this.canInsert) {
                return 0;
            }
            return this.inventory.countSpace(stack);
        }

        @Override
        public int countSpace(FluidStack stack, int maxAmount, class_2350 side) {
            return this.countSpace(stack, maxAmount);
        }

        @Override
        public int countSpace(FluidStack stack, int maxAmount) {
            if (!this.canInsert) {
                return 0;
            }
            return this.inventory.countSpace(stack, maxAmount);
        }

        @Override
        public int extract(FluidStack stack, class_2350 side) {
            return this.extract(stack);
        }

        @Override
        public int extract(FluidStack stack) {
            if (!this.canExtract) {
                return 0;
            }
            return this.inventory.extract(stack);
        }

        @Override
        public int extract(FluidStack stack, int maxAmount, class_2350 side) {
            return this.extract(stack, maxAmount);
        }

        @Override
        public int extract(FluidStack stack, int maxAmount) {
            if (!this.canExtract) {
                return 0;
            }
            return this.inventory.extract(stack, maxAmount);
        }

        @Override
        public FluidStack extract(Predicate<FluidStack> predicate, class_2350 side) {
            return this.extract(predicate);
        }

        @Override
        public FluidStack extract(Predicate<FluidStack> predicate) {
            if (!this.canExtract) {
                return FluidStack.EMPTY;
            }
            return this.inventory.extract(predicate);
        }

        @Override
        public FluidStack extract(Predicate<FluidStack> predicate, int maxAmount, class_2350 side) {
            return this.extract(predicate, maxAmount);
        }

        @Override
        public FluidStack extract(Predicate<FluidStack> predicate, int maxAmount) {
            if (!this.canExtract) {
                return FluidStack.EMPTY;
            }
            return this.inventory.extract(predicate, maxAmount);
        }

        @Override
        public FluidStack extractAny(class_2350 side) {
            return this.extractAny();
        }

        @Override
        public FluidStack extractAny() {
            if (!this.canExtract) {
                return FluidStack.EMPTY;
            }
            return this.inventory.extractAny();
        }

        @Override
        public FluidStack extractAny(int maxAmount, class_2350 side) {
            return this.extractAny(maxAmount);
        }

        @Override
        public FluidStack extractAny(int maxAmount) {
            if (!this.canExtract) {
                return FluidStack.EMPTY;
            }
            return this.inventory.extractAny(maxAmount);
        }

        @Override
        public int[] getAvailableSlots(class_2350 side) {
            return this.slots;
        }

        @Override
        public int getMaxAmountPerStack() {
            return this.inventory.getMaxAmountPerStack();
        }

        @Override
        public FluidStack getStack(int slot) {
            return this.inventory.getStack(slot);
        }

        @Override
        public int insert(FluidStack stack, class_2350 side) {
            return this.insert(stack);
        }

        @Override
        public int insert(FluidStack stack) {
            if (!this.canInsert) {
                return 0;
            }
            return this.inventory.insert(stack);
        }

        @Override
        public int insert(FluidStack stack, int maxAmount, class_2350 side) {
            return this.insert(stack, maxAmount);
        }

        @Override
        public int insert(FluidStack stack, int maxAmount) {
            if (!this.canInsert) {
                return 0;
            }
            return this.inventory.insert(stack, maxAmount);
        }

        @Override
        public List<FluidStack> insert(List<FluidStack> stacks, class_2350 side) {
            return this.insert(stacks);
        }

        @Override
        public List<FluidStack> insert(List<FluidStack> stacks) {
            if (!this.canInsert) {
                return stacks;
            }
            return this.inventory.insert(stacks);
        }

        @Override
        public int insertExist(FluidStack stack, class_2350 side) {
            return this.insertExist(stack);
        }

        @Override
        public int insertExist(FluidStack stack) {
            if (!this.canInsert) {
                return 0;
            }
            return this.inventory.insertExist(stack);
        }

        @Override
        public boolean isEmpty() {
            return this.inventory.isEmpty();
        }

        @Override
        @NotNull
        public java.util.Iterator<FluidStack> iterator() {
            return this.inventory.iterator();
        }

        @Override
        @NotNull
        public java.util.Iterator<FluidStack> iterator(class_2350 side) {
            return this.inventory.iterator();
        }

        @Override
        public boolean preciseExtract(FluidStack stack, class_2350 side) {
            return this.preciseExtract(stack);
        }

        @Override
        public boolean preciseExtract(FluidStack stack) {
            if (!this.canExtract) {
                return stack.isEmpty();
            }
            return this.inventory.preciseExtract(stack);
        }

        @Override
        public FluidStack preciseExtract(Predicate<FluidStack> predicate, int maxAmount, class_2350 side) {
            return this.preciseExtract(predicate, maxAmount);
        }

        @Override
        public FluidStack preciseExtract(Predicate<FluidStack> predicate, int maxAmount) {
            if (!this.canExtract) {
                return FluidStack.EMPTY;
            }
            return this.inventory.preciseExtract(predicate, maxAmount);
        }

        @Override
        public boolean preciseInsert(FluidStack stack, class_2350 side) {
            return this.preciseInsert(stack);
        }

        @Override
        public boolean preciseInsert(FluidStack stack) {
            if (!this.canInsert) {
                return stack.isEmpty();
            }
            return this.inventory.preciseInsert(stack);
        }

        @Override
        public boolean preciseInsert(FluidStack stack, int maxAmount, class_2350 side) {
            return this.preciseInsert(stack, maxAmount);
        }

        @Override
        public boolean preciseInsert(FluidStack stack, int maxAmount) {
            if (!this.canInsert) {
                return stack.isEmpty();
            }
            return this.inventory.preciseInsert(stack, maxAmount);
        }

        @Override
        public boolean preciseInsert(List<FluidStack> stacks, class_2350 side) {
            return this.preciseInsert(stacks);
        }

        @Override
        public boolean preciseInsert(List<FluidStack> stacks) {
            if (!this.canInsert) {
                return false;
            }
            return this.inventory.preciseInsert(stacks);
        }

        @Override
        public FluidStack removeStack(int slot) {
            if (!this.canExtract) {
                return FluidStack.EMPTY;
            }
            return this.inventory.removeStack(slot);
        }

        @Override
        public FluidStack removeStack(int slot, int amount) {
            if (!this.canExtract) {
                return FluidStack.EMPTY;
            }
            return this.inventory.removeStack(slot, amount);
        }

        @Override
        public void setStack(int slot, FluidStack stack) {
            this.inventory.setStack(slot, stack);
        }

        @Override
        public int size() {
            return this.inventory.size();
        }

        @Override
        public Stream<FluidStack> stream() {
            return this.inventory.stream();
        }

        @Override
        public Stream<FluidStack> stream(class_2350 side) {
            return this.inventory.stream();
        }
    }

    static class Iterator
    implements java.util.Iterator<FluidStack> {
        private final java.util.Iterator<StorageView<FluidVariant>> iterator;

        public Iterator(Storage<FluidVariant> storage) {
            this.iterator = storage.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public FluidStack next() {
            StorageView<FluidVariant> view = this.iterator.next();
            FluidVariant variant = (FluidVariant)view.getResource();
            return new FluidStack(variant.getFluid(), view.getAmount(), variant.getComponents());
        }
    }
}

